'use strict';

/* --------------------------------------------------------------
 zones_handler.js 2017-06-01
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * The Component for handling the federal state dropdown depending on the country.
 * The field will be blacked out if there are no federal states for the selected
 * country.
 */
gambio.widgets.module('zones_handler', ['form', 'xhr'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $states = $('select#state.form-control'),
        $selectedState = $('input[name=selected_zone_id]'),
        $statesFormGroup = $('select#state.form-control').closest('div.form-group'),
        defaults = {
        loadStates: 'shop.php?do=Zones',
        country: 'select#country.form-control'
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    var _changeHandler = function _changeHandler() {

        var dataset = jse.libs.form.getData($this);

        jse.libs.xhr.ajax({ url: options.loadStates, data: dataset }, true).done(function (result) {

            if (result.success) {

                $states.children('option').remove();
                $selectedState.prop("disabled", false);
                $states.prop("disabled", false);

                $.each(result.data, function (key, value) {

                    if (value.selected) {
                        $states.append($("<option selected/>").val(value.id).text(value.name));
                    } else {
                        $states.append($("<option />").val(value.id).text(value.name));
                    }
                });

                $statesFormGroup.removeClass('hidden').show();
            } else {

                $statesFormGroup.hide();
                $selectedState.prop("disabled", true);
                $states.prop("disabled", true);
            }
        });
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {

        _changeHandler();

        $this.on('change', options.country, _changeHandler);

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
